/***************************************************************************
* @brief global.h 
*	
*	Description : 
*				Contains the header file defintions used in the BLDC motor control example
*
* @note
* Copyright(C) NXP Semiconductors, 2014
* All rights reserved.
*
* Software that is described herein is for illustrative purposes only
* which provides customers with programming information regarding the
* LPC products.  This software is supplied "AS IS" without any warranties of
* any kind, and NXP Semiconductors and its licensor disclaim any and
* all warranties, express or implied, including all implied warranties of
* merchantability, fitness for a particular purpose and non-infringement of
* intellectual property rights.  NXP Semiconductors assumes no responsibility
* or liability for the use of the software, conveys no license or rights under any
* patent, copyright, mask work right, or any other intellectual property rights in
* or to any products. NXP Semiconductors reserves the right to make changes
* in the software without notification. NXP Semiconductors also makes no
* representation or warranty that such application will be suitable for the
* specified use without further testing or modification.
*
* Permission to use, copy, modify, and distribute this software and its
* documentation is hereby granted, under NXP Semiconductors' and its
* licensor's relevant copyrights in the software, without fee, provided that it
* is used in conjunction with NXP Semiconductors microcontrollers.  This
* copyright, permission, and disclaimer notice must appear in all copies of
* this code.
**********************************************************************************/
#include "LPC15xx.h"
#include "oled.h"
#include "gui.h"
#include "nxp_image.h"
#include "ea_image.h"
#include "lpc15xx_gpio.h"

void joystick_init (void);

#define sct_pre        ((SystemCoreClock/1000000)-1)       // SCT prescaler to make sure SCT input clock  is 1MHz
#define pwm_end        50 - 1                              // 50 usec = 20KHz pwm frequency

#define ST_HALTED              0                           // motor HALTED
#define ST_F_BOOST             1                           // motor forward boost up from speed zero
#define ST_R_BOOST             2                           // motor reverse boost up from speed zero
#define ST_FORWARD             3                           // motor runs forward
#define ST_REVERSE             4                           // motor runs reverse

#define JOY_D              (LPC_GPIO->PIN[1] & (1 << 8))   // P1_8 = JOY_DOWN
#define JOY_C              (LPC_GPIO->PIN[1] & (1 << 5))   // P1_5 = JOY_CENTER
#define JOY_U              (LPC_GPIO->PIN[1] & (1 << 7))   // P1_7 = JOY_UP
#define JOY_L              (LPC_GPIO->PIN[1] & (1 << 4))   // P1_4 = JOY_LEFT
#define JOY_R              (LPC_GPIO->PIN[1] & (1 << 6))   // P1_6 = JOY_RIGHT

#define HALL_A             (LPC_GPIO->PIN[0] & (1 << 2))   // P0_2  = HALL_A
#define HALL_B             (LPC_GPIO->PIN[0] & (1 << 30))   // P0_30  = HALL_B
#define HALL_C             (LPC_GPIO->PIN[0] & (1 << 17))  // P0_17 = HALL_C

#define GRAPH_LIMIT	64-8
#define MC_BOARD_ENABLE_OLED 1
extern void SCT0_Init(void);
